---
title: Example rules checking uploaded content objects · Cloudflare Web
  Application Firewall (WAF) docs
description: "This custom rule example logs all requests with at least one
  uploaded content object:"
lastUpdated: 2025-10-14T13:48:33.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/waf/detections/malicious-uploads/example-rules/
  md: https://developers.cloudflare.com/waf/detections/malicious-uploads/example-rules/index.md
---

## Log requests with an uploaded content object

This [custom rule](https://developers.cloudflare.com/waf/custom-rules/) example logs all requests with at least one uploaded content object:

* Expression: `cf.waf.content_scan.has_obj`
* Action: *Log*

## Block requests to URI path with a malicious content object

This custom rule example blocks requests addressed at `/upload.php` that contain at least one uploaded content object considered malicious:

* Expression: `cf.waf.content_scan.has_malicious_obj and http.request.uri.path eq "/upload.php"`
* Action: *Block*

## Block requests with non-PDF file uploads

This custom rule example blocks requests addressed at `/upload` with uploaded content objects that are not PDF files:

* Expression: `any(cf.waf.content_scan.obj_types[*] != "application/pdf") and http.request.uri.path eq "/upload"`
* Action: *Block*

## Block requests with uploaded files over 500 KB

This custom rule example blocks requests addressed at `/upload` with uploaded content objects over 500 KB (512,000 bytes) in size:

* Expression: `any(cf.waf.content_scan.obj_sizes[*] > 512000) and http.request.uri.path eq "/upload"`
* Action: *Block*

## Block requests with uploaded files over the content scanning limit (50 MB)

This custom rule example blocks requests with uploaded content objects over 50 MB in size (the current content scanning limit):

* Expression: `any(cf.waf.content_scan.obj_sizes[*] >= 52428800)`
* Action: *Block*

In this example, you must also test for equality because currently any file over 50 MB will be handled internally as if it had a size of 50 MB (52,428,800 bytes). This means that using the `>` (greater than) [comparison operator](https://developers.cloudflare.com/ruleset-engine/rules-language/operators/#comparison-operators) would not work for this particular rule — you should use `>=` (greater than or equal) instead.
