---
title: Redirect requests to a different hostname · Cloudflare Rules docs
description: Create a redirect rule to redirect all requests for
  `smallshop.example.com` to a different hostname using HTTPS, keeping the
  original path and query string.
lastUpdated: 2025-10-13T13:40:40.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/rules/url-forwarding/examples/redirect-all-different-hostname/
  md: https://developers.cloudflare.com/rules/url-forwarding/examples/redirect-all-different-hostname/index.md
---

This example single redirect will redirect all requests for `smallshop.example.com` to a different hostname `globalstore.example.net` using HTTPS, keeping the original path and query string.

**When incoming requests match**

* **Wildcard pattern**
  * **Request URL**: `http*://smallshop.example.com/*`

**Then**

* **Target URL**: `https://globalstore.example.net/${2}`
* **Status code:** *301*
* **Preserve query string:** Enabled

For example, the redirect rule would perform the following redirects:

| Request URL | Target URL | Status code |
| - | - | - |
| `http://smallshop.example.com/` | `https://globalstore.example.net/` | `301` |
| `http://smallshop.example.com/admin/?logged_out=true` | `https://globalstore.example.net/admin/?logged_out=true` | `301` |
| `https://smallshop.example.com/?all_items=1` | `https://globalstore.example.net/?all_items=1` | `301` |
| `http://example.com/about/` | (unchanged) | n/a |
